/*
 * Decompiled with CFR 0.152.
 */
package net.adaptivebox.deps.behavior;

import net.adaptivebox.deps.behavior.AbsGTBehavior;
import net.adaptivebox.global.RandomGenerator;
import net.adaptivebox.goodness.IGoodnessCompareEngine;
import net.adaptivebox.knowledge.ILibEngine;
import net.adaptivebox.knowledge.Library;
import net.adaptivebox.knowledge.SearchPoint;
import net.adaptivebox.problem.ProblemEncoder;
import net.adaptivebox.space.BasicPoint;

public class DEGTBehavior
extends AbsGTBehavior
implements ILibEngine {
    private static final int DVNum = 2;
    public double MIN_FACTOR = 0.5;
    public double MAX_FACTOR = 0.5;
    public double CR = 0.9;
    private SearchPoint pbest_t;

    public void setPbest(SearchPoint searchPoint) {
        this.pbest_t = searchPoint;
    }

    private void crossoverAndMutation(int n, double[] dArray, double[] dArray2, BasicPoint[] basicPointArray) {
        double d = 0.0;
        for (int i = 0; i < basicPointArray.length; ++i) {
            d += (i % 2 == 0 ? 1.0 : -1.0) * basicPointArray[i].getLocation()[n];
        }
        dArray[n] = dArray2[n] + RandomGenerator.doubleRangeRandom(this.MIN_FACTOR, this.MAX_FACTOR) * d;
    }

    @Override
    public void generateBehavior(SearchPoint searchPoint, ProblemEncoder problemEncoder) {
        int n;
        BasicPoint[] basicPointArray = this.getReferPoints();
        int n2 = problemEncoder.getDesignSpace().getDimension();
        int n3 = RandomGenerator.intRangeRandom(0, n2 - 1);
        double[] dArray = searchPoint.getLocation();
        double[] dArray2 = this.pbest_t.getLocation();
        double[] dArray3 = this.socialLib.getGbest().getLocation();
        for (n = 0; n < n3; ++n) {
            if (this.CR <= Math.random()) {
                dArray[n] = dArray2[n];
                continue;
            }
            this.crossoverAndMutation(n, dArray, dArray3, basicPointArray);
        }
        this.crossoverAndMutation(n3, dArray, dArray3, basicPointArray);
        for (n = n3 + 1; n < n2; ++n) {
            if (this.CR <= Math.random()) {
                dArray[n] = dArray2[n];
                continue;
            }
            this.crossoverAndMutation(n, dArray, dArray3, basicPointArray);
        }
    }

    @Override
    public void testBehavior(SearchPoint searchPoint, IGoodnessCompareEngine iGoodnessCompareEngine) {
        Library.replace(iGoodnessCompareEngine, searchPoint, this.pbest_t);
    }

    private SearchPoint[] getReferPoints() {
        SearchPoint[] searchPointArray = new SearchPoint[4];
        for (int i = 0; i < searchPointArray.length; ++i) {
            searchPointArray[i] = this.socialLib.getSelectedPoint(RandomGenerator.intRangeRandom(0, this.socialLib.getPopSize() - 1));
        }
        return searchPointArray;
    }
}

